<?php
/**
 * Created by PhpStorm.
 * User: AGO
 * Date: 05/06/2020
 * Time: 15:48
 */

namespace Koralp\Email;

use \Mailjet\Resources;

class Mailjet
{
    private $api_key;
    private $secret_key;

    /**
     * Mailjet constructor.
     * @param $api_key
     * @param $secret_key
     */
    public function __construct($api_key, $secret_key)
    {
        $this->api_key = $api_key;
        $this->secret_key = $secret_key;
    }

    /**
     * @param string $send_name
     * @param string $sender_email
     * @param string $recipient_name
     * @param string $recipient_email
     * @param array $email_variables
     * @param int $template_id
     * @param string $subject
     * @return array|bool
     */
    public function sendWithTemplate(
        string $send_name,
        string $sender_email,
        string $recipient_name,
        string $recipient_email,
        array $email_variables,
        int $template_id,
        string $subject = NULL,
        string $cc_email = NULL,
        string $cc_name = NULL)
    {
        $mj = new \Mailjet\Client($this->api_key, $this->secret_key, true, ['version' => 'v3.1']);
        if($subject == NULL){
            $body = [
                'Messages' => [
                    [
                        'From' => [
                            'Email' => $sender_email,
                            'Name' => $send_name
                        ],
                        'To' => [
                            [
                                'Email' => $recipient_email,
                                'Name' => $recipient_name
                            ]
                        ],
                        'TemplateID' => $template_id,
                        'TemplateLanguage' => true,
                        'Variables' => $email_variables,
                        'TemplateErrorReporting' => [
                            'Email' => 'informatique@koralp.com',
                            'Name' => 'IT',
                        ],
                    ]
                ]
            ];
            if ($cc_email != null and $cc_name != null) {
                $body['Messages'][0]['Cc'] = [['Email' => $cc_email, 'Name' => $cc_name]];
            }
        }
        else{
            $body = [
                'Messages' => [
                    [
                        'From' => [
                            'Email' => $sender_email,
                            'Name' => $send_name
                        ],
                        'To' => [
                            [
                                'Email' => $recipient_email,
                                'Name' => $recipient_name
                            ]
                        ],
                        'TemplateID' => $template_id,
                        'TemplateLanguage' => true,
                        'Subject' => $subject,
                        'Variables' => $email_variables,
                        'TemplateErrorReporting' => [
                            'Email' => 'informatique@koralp.com',
                            'Name' => 'IT',
                        ],
                    ]
                ]
            ];
            if ($cc_email != null and $cc_name != null) {
                $body['Messages'][0]['Cc'] = [['Email' => $cc_email, 'Name' => $cc_name]];
            }
        }


        $response = $mj->post(Resources::$Email, ['body' => $body]);

        if(!$response->success()){
            return false;
        }

        $result = $response->getData();

        return $result['Messages'][0];
    }

    /**
     * @param $emai_id
     * @return array|bool
     */
    public function getEmailInfo($emai_id){
        $mj = new \Mailjet\Client($this->api_key, $this->secret_key);
        $response = $mj->get(Resources::$Message, ['id' => $emai_id]);
        if(!$response->success()){
            return false;
        }
        return $response->getData();
    }

    /**
     * @param $email_id
     * @return array|bool
     */
    public function getEmailHistory($email_id){
        $mj = new \Mailjet\Client(API_KEY, SECRET_KEY);
        $response = $mj->get(Resources::$Messagehistory, ['id' => $email_id]);
        if(!$response->success()){
            return false;
        }
         return $response->getData();
    }

}
