<?php
/**
 * Created by PhpStorm.
 * User: AGO
 * Date: 05/06/2020
 * Time: 15:48
 */

namespace Koralp\Kerong;


class Lock
{    
    // CONSTANT DATA start & end HEXA
    const LOCK_DATA_START = 'F5';
    const LOCK_DATA_END = '5F';

    // CONSTANT ACTION HEXA
    const LOCK_ACTION_STATUS = '70';
    const LOCK_ACTION_OPEN = '71';
    const LOCK_ACTION_LIGHT = '72';
    const LOCK_ACTION_LED = '73';
    const LOCK_ACTION_CLUSTER = '7E';

    // CONSTANT ACTION LED HEXA
    const LOCK_ACTION_LED_GREEN = '1';
    const LOCK_ACTION_LED_RED = '2';
    const LOCK_ACTION_LED_OFF = '0';

    // CONSTANT ACTION LIGHT HEXA
    const LOCK_ACTION_LIGHT_OFF = '0';
    const LOCK_ACTION_LIGHT_ON = '1';
    const LOCK_ACTION_LIGHT_ON_2M = '2';

    // CONSTANT STATUS DEC
    const LOCK_STATUS_LED_RED = 32;
    const LOCK_STATUS_LED_GREEN = 16;
    const LOCK_STATUS_LIGHT = 8;
    const LOCK_STATUS_DETECT = 4;
    const LOCK_STATUS_CLOSE = 1;

    // VARIABLES
    private $address;
    private $port;
    private $lockerNumber;

    /**
     * Lock constructor.
     * @param $address
     * @param $port
     * @param $lockerNumber
     */
    public function __construct($address, $port, $lockerNumber)
    {
        $this->address = $address;
        $this->port = $port;
        $this->lockerNumber = $lockerNumber;
    }

    /**
     * Get lock status
     * @return false|string
     */
    public function getStatus(){
        $command = $this->generateStatusCommand();
        $result = $this->sendCommand($command);

        $result = hexdec(substr($result, -2));

        $lock_close = false;
        $detect = false;
        $light = false;
        $led_green = false;
        $led_red = false;

        $status = [
            self::LOCK_STATUS_CLOSE => false,
            self::LOCK_STATUS_DETECT => false,
            self::LOCK_STATUS_LIGHT => false,
            self::LOCK_STATUS_LED_GREEN => false,
            self::LOCK_STATUS_LED_RED => false,
        ];

        if($result >= self::LOCK_STATUS_LED_RED){
            $status[self::LOCK_STATUS_LED_RED] = true;
            $result -= self::LOCK_STATUS_LED_RED;
        }
        if($result >= self::LOCK_STATUS_LED_GREEN && $result < self::LOCK_STATUS_LED_RED){
            $status[self::LOCK_STATUS_LED_GREEN] = true;
            $result -= self::LOCK_STATUS_LED_GREEN;
        }
        if($result >= self::LOCK_STATUS_LIGHT && $result < self::LOCK_STATUS_LED_GREEN){
            $status[self::LOCK_STATUS_LIGHT] = true;
            $result -= self::LOCK_STATUS_LIGHT;
        }
        if($result >= self::LOCK_STATUS_DETECT && $result < self::LOCK_STATUS_LIGHT){
            $status[self::LOCK_STATUS_DETECT] = true;
            $result -= self::LOCK_STATUS_DETECT;
        }
        if($result >= self::LOCK_STATUS_CLOSE && $result < self::LOCK_STATUS_DETECT){
            $status[self::LOCK_STATUS_CLOSE] = true;
            $result -= self::LOCK_STATUS_CLOSE;
        }

        return $status;
    }

    /**
     * Open lock
     */
    public function open(){
        $command = $this->generateOpenCommand(self::LOCK_ACTION_OPEN);
        $result = $this->sendCommand($command);
    }

    /**
     * LED indicator GREEN on
     */
    public function ledGreen(){
        $command = $this->generateLedCommand(self::LOCK_ACTION_LED_GREEN);
        $result = $this->sendCommand($command);
    }

    /**
     * LED indicator RED on
     */
    public function ledRed(){
        $command = $this->generateLedCommand(self::LOCK_ACTION_LED_RED);
        $result = $this->sendCommand($command);
    }

    /**
     * LED indicator OFF
     */
    public function ledOff(){
        $command = $this->generateLedCommand(self::LOCK_ACTION_LED_OFF);
        $result = $this->sendCommand($command);
    }

    /**
     * LIGHT off
     */
    public function lightOff(){
        $command = $this->generateLightCommand(self::LOCK_ACTION_LIGHT_OFF);
        $result = $this->sendCommand($command);
    }

    /**
     * LIGHT on
     */
    public function lightOn(){
        $command = $this->generateLightCommand(self::LOCK_ACTION_LIGHT_ON);
        $result = $this->sendCommand($command);
    }

    /**
     * LIGHT on 2 minutes
     */
    public function lightOn2m(){
        $command = $this->generateLightCommand(self::LOCK_ACTION_LIGHT_ON_2M);
        $result = $this->sendCommand($command);
    }


    /**
     * @return string
     */
    private function generateStatusCommand(){
        $command = '';

        $sum = hexdec(self::LOCK_DATA_START) + $this->lockerNumber + hexdec(self::LOCK_ACTION_STATUS) + 0 + 0 + hexdec(SELF::LOCK_DATA_END);
        $sum_hex = dechex($sum);
        $checksum = hexdec(substr($sum_hex, -2));
        $command .= chr((int)hexdec(self::LOCK_DATA_START));
        $command .= chr((int)$this->lockerNumber);
        $command .= chr((int)hexdec(self::LOCK_ACTION_STATUS));
        $command .= chr(0X00);
        $command .= chr(0X00);
        $command .= chr((int)hexdec(SELF::LOCK_DATA_END));
        $command .= chr((int)$checksum);
        $command .= chr(0X00);
        return $command;
    }

    /**
     * @param $action
     * @return string
     */
    private function generateOpenCommand($action){
        $command = '';

        $sum = hexdec(self::LOCK_DATA_START) + $this->lockerNumber + hexdec(self::LOCK_ACTION_OPEN) + 0 + 1 + hexdec(SELF::LOCK_DATA_END);
        $sum_hex = dechex($sum);
        $checksum = hexdec(substr($sum_hex, -2));
        $command .= chr((int)hexdec(self::LOCK_DATA_START));
        $command .= chr((int)$this->lockerNumber);
        $command .= chr((int)hexdec(self::LOCK_ACTION_OPEN));
        $command .= chr(0X00);
        $command .= chr(0X01);
        $command .= chr((int)hexdec(SELF::LOCK_DATA_END));
        $command .= chr((int)$checksum);
        $command .= chr(0X00);
        return $command;
    }

    /**
     * @param $action
     * @return string
     */
    private function generateLedCommand($action){
        $command= '';
        $sum = hexdec(self::LOCK_DATA_START) + $this->lockerNumber + hexdec(self::LOCK_ACTION_LED) + 0 + 1 + hexdec(SELF::LOCK_DATA_END) + hexdec($action);
        $sum_hex = dechex($sum);
        $checksum = hexdec(substr($sum_hex, -2));
        $command .= chr((int)hexdec(self::LOCK_DATA_START));
        $command .= chr((int)$this->lockerNumber);
        $command .= chr((int)hexdec(self::LOCK_ACTION_LED));
        $command .= chr(0X00);
        $command .= chr(0X01);
        $command .= chr((int)hexdec(SELF::LOCK_DATA_END));
        $command .= chr((int)$checksum);
        $command .= chr((int)hexdec($action));

        return $command;
    }

    /**
     * @param $action
     * @return string
     */
    private function generateLightCommand($action){
        $command= '';
        $sum = hexdec(self::LOCK_DATA_START) + $this->lockerNumber + hexdec(self::LOCK_ACTION_LIGHT) + 0 + 1 + hexdec(SELF::LOCK_DATA_END) + hexdec($action);
        $sum_hex = dechex($sum);
        $checksum = hexdec(substr($sum_hex, -2));
        $command .= chr((int)hexdec(self::LOCK_DATA_START));
        $command .= chr((int)$this->lockerNumber);
        $command .= chr((int)hexdec(self::LOCK_ACTION_LIGHT));
        $command .= chr(0X00);
        $command .= chr(0X01);
        $command .= chr((int)hexdec(SELF::LOCK_DATA_END));
        $command .= chr((int)$checksum);
        $command .= chr((int)hexdec($action));

        return $command;
    }

    /**
     * @param $command
     * @return false|string
     */
    private function sendCommand($command){
        /* Create a TCP/IP socket. */
        $socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
        if ($socket === false) {
            echo "socket_create() failed: reason: " .
                socket_strerror(socket_last_error()) . "\n";
        }

        //echo "Attempting to connect to '$this->address' on port '$this->port'...<br>";
        $result = socket_connect($socket, $this->address, $this->port);
        if ($result === false) {
            echo "socket_connect() failed.\nReason: ($result) " .
                socket_strerror(socket_last_error($socket)) . "<br>";
        }


        //echo "Sending open request...";
        socket_write($socket, $command, strlen($command));
        //echo "OK.<br>";

        //echo "Reading response:<br><br>";
        $reply = socket_read($socket, 2048);
        //echo bin2hex($reply);

        socket_close($socket);

        return bin2hex($reply);

    }

}