<?php

namespace Koralp\Kerong;

class MultiLock
{
    // CONSTANT DATA start & end HEXA
    const LOCK_DATA_START = '02';
    const LOCK_DATA_END = '03';

    // CONSTANT ACTION HEXA
    const LOCK_ACTION_STATUS = '30';
    const LOCK_ACTION_OPEN = '31';

    // VARIABLES
    private $ipAdress;
    private $port;

    /**
     * @param $ipAdress
     * @param $port
     */
    public function __construct($ipAdress, $port)
    {
        $this->ipAdress = $ipAdress;
        $this->port = $port;
    }

    /**
     * @param $lockNumber
     * @param $boardNumbeer
     * @return false|string
     */
    public function openLock($lockNumber,$boardNumber){
        $command = $this->generateOpenCommand($lockNumber,$boardNumber);
        $result = $this->sendCommand($command);

        return $result;
    }

    /**
     * @param $lockNumber
     * @param $boardNumber
     * @return false|string
     */
    public function getStatus($lockNumber,$boardNumber){
        $command = $this->generateStatusCommand($lockNumber,$boardNumber);
        $result = $this->sendCommand($command);

        return $result;
    }


    /**
     * @param $lockNumber
     * @param $boardNumbeer
     * @return string
     */
    private function generateOpenCommand($lockNumber,$boardNumber){
        $command = '';

        $lockNumberFormated = dechex($boardNumber).dechex($lockNumber);
        $lockNumberFormated = hexdec($lockNumberFormated);

        $sum = hexdec(self::LOCK_DATA_START) + $lockNumberFormated + hexdec(self::LOCK_ACTION_OPEN) + hexdec(self::LOCK_DATA_END);
        $sum_hex = dechex($sum);
        $checksum = hexdec(substr($sum_hex, -2));
        $command .= chr((int)hexdec(self::LOCK_DATA_START));
        $command .= chr((int)$lockNumberFormated);
        $command .= chr((int)hexdec(self::LOCK_ACTION_OPEN));
        $command .= chr((int)hexdec(self::LOCK_DATA_END));
        $command .= chr((int)$checksum);
        return $command;
    }

    /**
     * @param $lockNumber
     * @param $boardNumber
     * @return string
     */
    private function generateStatusCommand($lockNumber,$boardNumber){
        $command = '';

        $lockNumberFormated = dechex($boardNumber).dechex($lockNumber);
        $lockNumberFormated = hexdec($lockNumberFormated);

        $sum = hexdec(self::LOCK_DATA_START) + $lockNumberFormated + hexdec(self::LOCK_ACTION_OPEN) + hexdec(self::LOCK_DATA_END);
        $sum_hex = dechex($sum);
        $checksum = hexdec(substr($sum_hex, -2));
        $command .= chr((int)hexdec(self::LOCK_DATA_START));
        $command .= chr((int)$lockNumberFormated);
        $command .= chr((int)hexdec(self::LOCK_ACTION_STATUS));
        $command .= chr((int)hexdec(self::LOCK_DATA_END));
        $command .= chr((int)$checksum);
        return $command;
    }

    /**
     * @param $command
     * @return false|string
     */
    private function sendCommand($command){
        /* Create a TCP/IP socket. */
        $socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
        if ($socket === false) {
            echo "socket_create() failed: reason: " .
                socket_strerror(socket_last_error()) . "\n";
        }

        //echo "Attempting to connect to '$this->address' on port '$this->port'...<br>";
        $result = socket_connect($socket, $this->ipAdress, $this->port);
        if ($result === false) {
            echo "socket_connect() failed.\nReason: ($result) " .
                socket_strerror(socket_last_error($socket)) . "<br>";
        }


        //echo "Sending open request...";
        socket_write($socket, $command, strlen($command));
        //echo "OK.<br>";

        //echo "Reading response:<br><br>";
        //$reply = socket_read($socket, 1024);
        //echo bin2hex($reply);

        socket_close($socket);

        //return bin2hex($reply);

    }

}