<?php
include_once 'vendor/autoload.php';

use Koralp\Kerong;

$lock = new Kerong\Lock('192.168.16.30',5000,0);

if(isset($_GET['action']) && $_GET['action'] == 'open'){
    $lock->open();
    tempo();
    header('location: test_lock.php');
    exit;
}
if(isset($_GET['action']) && $_GET['action'] == 'light_on'){
    $lock->lightOn();
    tempo();
    header('location: test_lock.php');
    exit;
}
if(isset($_GET['action']) && $_GET['action'] == 'light_on_2m'){
    $lock->lightOn2m();
    tempo();
    header('location: test_lock.php');
    exit;
}
if(isset($_GET['action']) && $_GET['action'] == 'light_off'){
    $lock->lightOff();
    tempo();
    header('location: test_lock.php');
    exit;
}

if(isset($_GET['action']) && $_GET['action'] == 'led_red'){
    $lock->ledRed();
    tempo();
    header('location: test_lock.php');
    exit;
}

if(isset($_GET['action']) && $_GET['action'] == 'led_green'){
    $lock->ledGreen();
    tempo();
    header('location: test_lock.php');
    exit;
}

if(isset($_GET['action']) && $_GET['action'] == 'led_off'){
    $lock->ledOff();
    tempo();
    header('location: test_lock.php');
    exit;
}

function tempo(){
    usleep(500000);
}



// Test get lock status
$status = $lock->getStatus();
//var_dump($status);die();



// Test open
//$lock->open();
//sleep(1);

// Test green LED
//$lock->ledGreen();
//sleep(1);

// Test red LED
//$lock->ledRed();
//sleep(1);

// Test LED off
//$lock->ledOff();

//Test Light On
//$lock->lightOn();

//Test Light Off
//$lock->lightOff();

//Test Light On 2 minutes
//$lock->lightOn2m();

?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Kerong</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
</head>
<body>
    <div class="container">
        <h1 class="text-center">Kerong</h1>
        <hr>
        <table class="table">
            <thead>
                <tr>
                    <th>Serrure fermée</th>
                    <th>Objet détécté</th>
                    <th>Lumière allumée</th>
                    <th>LED verte allumée</th>
                    <th>LED rouge allumée</th>
                </tr>
            </thead>
            <tbody style="text-align: center">
                <tr>
                    <td><?= ($status[$lock::LOCK_STATUS_CLOSE])?'x':'&nbsp;' ?></td>
                    <td><?= ($status[$lock::LOCK_STATUS_DETECT])?'x':'&nbsp;' ?></td>
                    <td><?= ($status[$lock::LOCK_STATUS_LIGHT])?'x':'&nbsp;' ?></td>
                    <td><?= ($status[$lock::LOCK_STATUS_LED_GREEN])?'x':'&nbsp;' ?></td>
                    <td><?= ($status[$lock::LOCK_STATUS_LED_RED])?'x':'&nbsp;' ?></td>
                </tr>
            </tbody>
        </table>
        <div>
            <a href="test_lock.php?action=open" class="btn btn-primary">Ouvrir</a>
        </div>
        <br>
        <div>
            <a href="test_lock.php?action=light_on" class="btn btn-primary">Allumer lumière</a>
            <a href="test_lock.php?action=light_on_2m" class="btn btn-secondary">Allumer lumière 2m</a>
            <a href="test_lock.php?action=light_off" class="btn btn-warning">Eteindre lumière</a>
        </div>
        <br>
        <div>
            <a href="test_lock.php?action=led_red" class="btn btn-danger">Allumer led rouge</a>
            <a href="test_lock.php?action=led_green" class="btn btn-success">Allumer led verte</a>
            <a href="test_lock.php?action=led_off" class="btn btn-secondary">Eteindre led</a>
        </div>
    </div>
    

</body>
</html>





