<?php

namespace Koralp\Kerong;

class MultiLock
{
    // CONSTANT DATA start & end HEXA
    const LOCK_DATA_START = '02';
    const LOCK_DATA_END = '03';

    // CONSTANT ACTION HEXA
    const LOCK_ACTION_STATUS = '30';
    const LOCK_ACTION_OPEN = '31';

    // VARIABLES
    private $ipAddress;
    private $port;

    /**
     * @param $ipAdress
     * @param $port
     */
    public function __construct($ipAddress, $port)
    {
        $this->ipAddress = $ipAddress;
        $this->port = $port;
    }

    /**
     * @param $lockNumber
     * @param $boardNumber
     * @return false|string
     */
    public function openLock($lockNumber,$boardNumber = 0){
        $command = $this->generateOpenCommand($lockNumber,$boardNumber);
        $result = $this->sendCommand($command);

        return $result;
    }

    /**
     * @param $lockNumber
     * @param $boardNumber
     * @return false|string
     */
    public function getStatus($lockNumber,$boardNumber){
        $command = $this->generateStatusCommand($lockNumber,$boardNumber);
        $result = $this->sendCommand($command);

        return $result;
    }


    /**
     * @param $lockNumber
     * @param $boardNumbeer
     * @return string
     */
    private function generateOpenCommand($lockNumber,$boardNumber){
        $command = '';

        $lockNumberFormated = dechex($boardNumber).dechex($lockNumber);
        $lockNumberFormated = hexdec($lockNumberFormated);

        $sum = hexdec(self::LOCK_DATA_START) + $lockNumberFormated + hexdec(self::LOCK_ACTION_OPEN) + hexdec(self::LOCK_DATA_END);
        $sum_hex = dechex($sum);
        $checksum = hexdec(substr($sum_hex, -2));
        $command .= chr((int)hexdec(self::LOCK_DATA_START));
        $command .= chr((int)$lockNumberFormated);
        $command .= chr((int)hexdec(self::LOCK_ACTION_OPEN));
        $command .= chr((int)hexdec(self::LOCK_DATA_END));
        $command .= chr((int)$checksum);
        return $command;
    }

    /**
     * @param $lockNumber
     * @param $boardNumber
     * @return string
     */
    private function generateStatusCommand($lockNumber,$boardNumber){
        $command = '';

        $lockNumberFormated = dechex($boardNumber).dechex($lockNumber);
        $lockNumberFormated = hexdec($lockNumberFormated);

        $sum = hexdec(self::LOCK_DATA_START) + $lockNumberFormated + hexdec(self::LOCK_ACTION_OPEN) + hexdec(self::LOCK_DATA_END);
        $sum_hex = dechex($sum);
        $checksum = hexdec(substr($sum_hex, -2));
        $command .= chr((int)hexdec(self::LOCK_DATA_START));
        $command .= chr((int)$lockNumberFormated);
        $command .= chr((int)hexdec(self::LOCK_ACTION_STATUS));
        $command .= chr((int)hexdec(self::LOCK_DATA_END));
        $command .= chr((int)$checksum);
        return $command;
    }

    /**
     * @param $command
     * @return false|string
     */
    private function sendCommand($command){
        $timeout = 2;
        $return = true;


        /* Create a TCP/IP socket. */
        try{
            $socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
            if ($socket === false) {
                /*echo "socket_create() failed: reason: " .
                    socket_strerror(socket_last_error()) . "\n";*/
                return false;
            }


            //echo "Attempting to connect to '$this->address' on port '$this->port'...<br>";

            // switch to non-blocking
            socket_set_nonblock($socket);
            // store the current time
            $time = time();
            //$result = socket_connect($socket, $this->address, $this->port);
            while (!$result=@socket_connect($socket, $this->ipAddress, $this->port)) {
                $err = socket_last_error($socket);

                // success!
                if($err === 56) {
                    exit;
                }

                // if timeout reaches then call exit();
                if ((time() - $time) >= $timeout) {

                    socket_close($socket);
                    return false;
                }
                // sleep for a bit
                usleep(250000);
            }



            // re-block the socket if needed
            socket_set_block($socket);
            if ($result === false) {
                /*echo "socket_connect() failed.\nReason: ($result) " .
                    socket_strerror(socket_last_error($socket)) . "<br>";*/
                return false;
            }



            //echo "Sending open request...";
            socket_set_option($socket, SOL_SOCKET, SO_SNDTIMEO, array('sec' => 1, 'usec' => 0));
            socket_write($socket, $command, strlen($command));
            //echo "OK.<br>";


            //echo "Reading response:<br><br>";
            socket_set_option($socket, SOL_SOCKET, SO_RCVTIMEO, array('sec' => 1, 'usec' => 0));
            $reply = '';
            $reply = socket_read($socket, 2048);
            //echo bin2hex($reply);

            socket_close($socket);


        }

        catch(\Exception $e){
            $return = false;
        }

        if($reply !== false){
            $return = bin2hex($reply);
        }
        return $return;

    }

}