<?php

namespace Koralp\Kimaldi;

use app\models\Locker;
use app\models\LockerOpenClose;
use app\models\Setting;
use Yii;

/**
 * Class Lock
 * @package Koralp\Kimaldi
 */
class Lock
{
    private $commandOpenLock = '';
    private $commandCloseLock = '';
    private $commandSetupLock = '';

    /**
     * @var string
     */
    private $ap200Ip;
    /**
     * @var string
     */
    private $ap200Port;

    /**
     * @var int
     */
    private $lockId;

    /**
     * @var int
     */
    private $currentLockId;

    /**
     * Lock constructor.
     * @param $ap200Ip string
     * @param $ap200Port string
     */
    public function __construct($ap200Ip,$ap200Port)
    {
        $this->ap200Ip = $ap200Ip;
        $this->ap200Port = $ap200Port;

        // Set open lock command
        $this->commandOpenLock = chr(0x15).chr(0x15).chr(0x00).chr(0x09)."LOCKID".chr(0x00).chr(0x01)."LATCHTIME".chr(0x30).chr(0x39);
        // Set close lock command
        $this->commandCloseLock = chr(0x15).chr(0x15).chr(0x00).chr(0x09)."LOCKID".chr(0x00).chr(0x00).chr(0x31).chr(0x31).chr(0x30);
        // Set setup lock command
        $this->commandSetupLock = chr(0x35).chr(0x35).chr(0x00).chr(0x09)."CURRENTLOCKID"."LOCKID".chr(0x0b);
    }

    /**
     * @param $id int
     * @return bool
     */
    public function open($lockId,$latchTime = 2){
        $this->lockId = $lockId;
        $lockIdEncoded = \Koralp\Skicase\Lock::encodeLockId($lockId);
        $command = str_replace('LOCKID',$lockIdEncoded,$this->commandOpenLock);
        $command = str_replace('LATCHTIME',$latchTime,$command);

        for($i = 0; $i < 5; $i++){
            $result = $this->sendCommand($command);
            if($result === true){
                break;
            }
        }

        return $result;
    }

    /**
     * @param $lockId int
     * @return bool
     */
    public function close($lockId){
        $this->lockId = $lockId;
        $lockIdEncoded = \Koralp\Skicase\Lock::encodeLockId($lockId);
        $command = str_replace('LOCKID',$lockIdEncoded,$this->commandCloseLock);

        for($i = 0; $i < 3; $i++){
            $result = $this->sendCommand($command);
            if($result === true){
                break;
            }
        }

        return $result;
    }

    /**
     * @param $lockId int
     * @param int $currentId int
     * @return bool
     */
    public function setup($lockId,$currentLockId = 1){
        $this->lockId = $lockId;
        $this->currentLockId = $currentLockId;
        // current lockId
        $lockIdEncoded = \Koralp\Skicase\Lock::encodeLockId($this->currentLockId);
        $command = str_replace('CURRENTLOCKID',$lockIdEncoded,$this->commandSetupLock);
        // new lockId
        $lockIdEncoded = \Koralp\Skicase\Lock::encodeLockId($lockId);
        $command = str_replace('LOCKID',$lockIdEncoded,$command);
        for($i = 0; $i < 3; $i++){
            $result = $this->sendCommand($command);
            if($result == true){
                break;
            }
        }

        return $result;
    }


    private function sendCommand($commande){
        $result = true;
        try {
            // AP200 connection
            $apConnection = fsockopen($this->ap200Ip, $this->ap200Port,$errno,$errstr,5);

            // Test if we are connected
            if(!$apConnection) {
                $result =  Yii::t('app','Impossible to send command to access point. Check access point connection.');
            }
            else{
                // We send the command
                fwrite($apConnection,$commande);

                $content = "";
                while (!feof($apConnection)) {
                    $content .= fread($apConnection, 1024);
                    $stream_meta_data = stream_get_meta_data($apConnection); //Added line
                    if($stream_meta_data['unread_bytes'] <= 0) break; //Added line
                }
                // We close connection
                fclose($apConnection);
            }

        } catch (\Exception $e) {
            $result =  Yii::t('app','Impossible to send command to access point. Check access point connection.');
        }

        return $result;
    }



}