<?php
/**
 * Created by PhpStorm.
 * User: AGO
 * Date: 19/06/2018
 * Time: 12:12
 */

namespace Koralp\Kimaldi;

use Yii;

class Ap200
{
    private $commandSetupRange;

    public function __construct()
    {
        $this->commandSetupRange = chr(0x15).chr(0x10).chr(0x00).chr(0x09).chr(0x0b)."START"."END";
    }

    /**
     * @param int $lockStart
     * @param int $lockEnd
     * @return bool|string
     */
    public function setupRange($ap200,$lockStart=1,$lockEnd=50){
        $result = true;
        $range = $lockEnd - $lockStart +1;
        if($range < 100){
            // Get encoded lock number
            $lockStartEncoded = \Koralp\Kimaldi\Tools::encodeLockId($lockStart);
            $lockEndEncoded = \Koralp\Kimaldi\Tools::encodeLockId($lockEnd);

            // Generate command with lock number
            $command = str_replace('START',$lockStartEncoded,$this->commandSetupRange);
            $command = str_replace('END',$lockEndEncoded,$command);

            try {
                // AP200 connection
                $apConnection = fsockopen($ap200->ip_address, $ap200->port,$errno,$errstr,5);

                // Test if we are connected
                if(!$apConnection) {
                    $result =  'Impossible to send command to access point. Check access point connection.';
                }
                else{
                    // We send the command
                    fwrite($apConnection,$command);

                    $content = "";
                    while (!feof($apConnection)) {
                        $content .= fread($apConnection, 1024);
                        $stream_meta_data = stream_get_meta_data($apConnection); //Added line
                        if($stream_meta_data['unread_bytes'] <= 0) break; //Added line
                    }
                    // We close connection
                    fclose($apConnection);
                }

            } catch (\Exception $e) {
                $result =  Yii::t('app','Impossible to send command to access point. Check access point connection.');
            }

            return $result;
        }
        else{
            $result = Yii::t('app','AP200 can not manage more than 100 locks.');
            return $result;
        }

    }

    /**
     * @param $ip IP
     * @param $port PORT
     * @param int $timeout TIMEOUT
     * @return bool
     */
    public static function checkConnection($ip,$port,$timeout = 5){
        $available = true;

        // AP200 connection
        try{
            $apConnection = fsockopen($ip, $port,$errno,$errstr,$timeout);

            // Test if we are connected
            if(!$apConnection) {
                $available =  false;
            }
            fclose($apConnection);
        }
        catch(\Exception $e){
            $available = false;
        }
        return $available;
    }

}