<?php

namespace Koralp\Metra;

class MLock
{
    // CONSTANT DATA start & end HEXA
    const LOCK_DATA_START = '02';
    const LOCK_DATA_END = '03';

    // CONSTANT ACTION HEXA
    const LOCK_ACTION_OPEN = '31';
    const LOCK_ACTION_DISABLE = '32';
    const LOCK_ACTION_ENABLE = '33';
    const LOCK_ACTION_OPEN_FORCE = '34';
    const LOCK_ACTION_GET_STATUS = '35';

    // VARIABLES
    private $ipAdress;
    private $port;

    /**
     * @param $ipAdress
     * @param $port
     */
    public function __construct($ipAdress, $port)
    {
        $this->ipAdress = $ipAdress;
        $this->port = $port;
    }

    /**
     * @param $lockNumber
     * @param $boardNumber
     * @return false|string
     */
    public function openLock($lockNumber,$boardNumber){
        $command = $this->generateCommand($lockNumber,$boardNumber,self::LOCK_ACTION_OPEN);
        $result = $this->sendCommand($command);

        return $result;
    }


    /**
     * @param $lockNumber
     * @param $boardNumber
     * @return false|string
     */
    public function disableLock($lockNumber,$boardNumber){
        $command = $this->generateCommand($lockNumber,$boardNumber,self::LOCK_ACTION_DISABLE);
        $result = $this->sendCommand($command);

        return $result;
    }


    /**
     * @param $lockNumber
     * @param $boardNumber
     * @return false|string
     */
    public function enableLock($lockNumber,$boardNumber){
        $command = $this->generateCommand($lockNumber,$boardNumber,self::LOCK_ACTION_ENABLE);
        $result = $this->sendCommand($command);

        return $result;
    }


    /**
     * @param $lockNumber
     * @param $boardNumber
     * @return false|string
     */
    public function openLockForce($lockNumber,$boardNumber){
        $command = $this->generateCommand($lockNumber,$boardNumber,self::LOCK_ACTION_OPEN_FORCE);
        $result = $this->sendCommand($command);

        return $result;
    }


    /**
     * @param $lockNumber
     * @param $boardNumber
     * @return false|string
     */
    public function getStatus($lockNumber,$boardNumber){
        $command = $this->generateCommand($lockNumber,$boardNumber,self::LOCK_ACTION_GET_STATUS);
        $result = $this->sendCommand($command);

        return $result;
    }


    /**
     * @param $lockNumber
     * @param $boardNumber
     * @param $action
     * @return string
     */
    private function generateCommand($lockNumber,$boardNumber,$action){
        $command = '';

        $lockNumberFormated = sprintf("%'.02d", $lockNumber);
        $boardNumberFormated = sprintf("%'.02d", $boardNumber);

        $sum = hexdec(self::LOCK_DATA_START) + $boardNumberFormated + $lockNumberFormated + hexdec($action) + hexdec(self::LOCK_DATA_END);
        $sum_hex = dechex($sum);
        $checksum = hexdec(substr($sum_hex, -2));
        $command .= chr((int)hexdec(self::LOCK_DATA_START));
        $command .= chr((int)$boardNumberFormated);
        $command .= chr((int)$lockNumberFormated);
        $command .= chr((int)hexdec($action));
        $command .= chr((int)hexdec(self::LOCK_DATA_END));
        $command .= chr((int)$checksum);
        return $command;
    }

    /**
     * @param $command
     * @return false|string
     */
    private function sendCommand($command){
        /* Create a UDP socket. */
        //$socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
        $socket = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP);;
        /*if ($socket === false) {
            echo "socket_create() failed: reason: " .
                socket_strerror(socket_last_error()) . "\n";
        }*/

        //echo "Attempting to connect to '$this->address' on port '$this->port'...<br>";
        //$result = socket_connect($socket, $this->ipAdress, $this->port);
        $len = strlen($command);
        $result = socket_sendto($socket, $command.'', $len, 0, $this->ipAdress, $this->port);
        if ($result === false) {
            echo "socket_connect() failed.\nReason: ($result) " .
                socket_strerror(socket_last_error($socket)) . "<br>";
        }
        if(socket_recv ($socket , $reply , 2045 , MSG_WAITALL ) === FALSE)
        {
            $errorcode = socket_last_error();
            $errormsg = socket_strerror($errorcode);

            die("Could not receive data: [$errorcode] $errormsg \n");
        }

        socket_close($socket);

        //echo "Sending open request...";
        //socket_write($socket, $command, strlen($command));
        //echo "OK.<br>";

        //echo "Reading response:<br><br>";
        //$reply = socket_read($socket, 1024);
        //echo bin2hex($reply);

        return bin2hex($reply);

    }

}