<?php
/**
 * Created by PhpStorm.
 * User: AGO
 * Date: 19/05/2020
 * Time: 00:06
 */

namespace Koralp\Payment;

/**
 * Class CreditAgricole
 * @package Koralp\Payment
 */
class CreditAgricole
{
    const VERSION = "00104";
    const TYPE_AUTH = "00001";// Autorisation
    const TYPE_CAPTURE = "00002";// Capture
    const TYPE_PAYMENT = "00003"; // Autorisation + capture
    const TYPE_CANCEL = "00005"; // Annulation de capture
    const TYPE_CHECK = "00011";
    const TYPE_REFUND = "00014"; // Remboursement
    const TYPE_CONSULTATION = "00017";
    const HASH = "SHA512";
    const URL_TEST = "https://preprod-ppps.paybox.com/PPPS.php";
    const URL_PROD = "https://ppps1.e-transactions.fr/PPPS.php";

    private $site;
    private $rang;
    private $devise;
    private $activite;
    private $key;
    private $url;

    /**
     * CreditAgricole constructor.
     * @param $env (URL_TEST or URL_PROD)
     * @param $key
     * @param $site
     * @param string $devise
     * @param string $rang
     * @param string $activite
     */
    function __construct($url,$key,$site,$devise = '978',$rang = '01',$activite = '024')
    {
        $this->url = $url;
        $this->key = $key;
        $this->site = $site;
        $this->devise = $devise;
        $this->rang = $rang;
        $this->activite = $activite;
    }

    /**
     * @param $ref
     * @param $amount
     * @param $cardId
     * @param $cardDate
     * @param $cardCvv
     * @param $urlRedirect
     * @param string $email
     */
    public function pay($ref,$amount,$cardId,$cardMonth,$cardYear,$cardCvv,$urlRedirect,$email = ''){
        if(strlen($cardYear) > 2){
            $cardYear = substr($cardYear, -2);
        }

        $MSG = "VERSION=".self::VERSION.
            "&TYPE=".self::TYPE_PAYMENT.
            "&SITE=".$this->site.
            "&RANG=".$this->rang.
            "&NUMQUESTION=".$this->getNumQuestion().
            "&MONTANT=".$amount.
            "&DEVISE=".$this->devise.
            "&REFERENCE=".$ref.
            "&EMAILPORTEUR=".$email.
            "&PORTEUR=".$cardId.
            "&HASH=".self::HASH.
            "&DATEVAL=".$cardMonth.$cardYear.
            "&CVV=".$cardCvv.
            "&ACTIVITE=".$this->activite.
            "&DATEQ=".$this->getCurrentDate();

        header('location: '.$urlRedirect.'?'. $this->executePayment($MSG));

    }

    /**
     * @param $ref
     * @param $amount
     * @param $cardId
     * @param $cardDate
     * @param $cardCvv
     * @param $urlRedirect
     * @param string $email
     */
    public function auth($ref,$amount,$cardId,$cardDate,$cardCvv,$urlRedirect,$email = ''){

        $MSG = "VERSION=".self::VERSION.
            "&TYPE=".self::TYPE_AUTH.
            "&SITE=".$this->site.
            "&RANG=".$this->rang.
            "&NUMQUESTION=".$this->getNumQuestion().
            "&MONTANT=".$amount.
            "&DEVISE=".$this->devise.
            "&REFERENCE=".$ref.
            "&EMAILPORTEUR=".$email.
            "&PORTEUR=".$cardId.
            "&HASH=".self::HASH.
            "&DATEVAL=".$cardDate.
            "&CVV=".$cardCvv.
            "&ACTIVITE=".$this->activite.
            "&DATEQ=".$this->getCurrentDate();

        header('location: '.$urlRedirect.'?'. $this->executePayment($MSG));

    }

    /**
     * @param $ref
     * @param $numappel
     * @param $numtrans
     * @param $amount
     * @param $urlRedirect
     */
    public function capture($ref,$numappel,$numtrans,$amount,$urlRedirect){

        $MSG = "VERSION=".self::VERSION.
            "&TYPE=".self::TYPE_CAPTURE.
            "&SITE=".$this->site.
            "&RANG=".$this->rang.
            "&NUMQUESTION=".$this->getNumQuestion().
            "&NUMAPPEL=".$numappel.
            "&NUMTRANS=".$numtrans.
            "&REFERENCE=".$ref.
            "&MONTANT=".$amount.
            "&DEVISE=".$this->devise.
            "&HASH=".self::HASH.
            "&DATEQ=".$this->getCurrentDate();

        header('location: '.$urlRedirect.'?'. $this->executePayment($MSG));

    }

    /**
     * @param $numappel
     * @param $numtrans
     * @param $amount
     * @param $urlRedirect
     */
    public function refund($numappel,$numtrans,$amount,$urlRedirect){

        $MSG = "VERSION=".self::VERSION.
            "&TYPE=".self::TYPE_REFUND.
            "&SITE=".$this->site.
            "&RANG=".$this->rang.
            "&NUMQUESTION=".$this->getNumQuestion().
            "&NUMAPPEL=".$numappel.
            "&NUMTRANS=".$numtrans.
            "&MONTANT=".$amount.
            "&DEVISE=".$this->devise.
            "&HASH=".self::HASH.
            "&DATEQ=".$this->getCurrentDate();

        header('location: '.$urlRedirect.'?'. $this->executePayment($MSG));

    }

    /**
     * @param $reference
     * @param $numappel
     * @param $numtrans
     * @param $amount
     * @param $urlRedirect
     */
    public function cancel($reference,$numappel,$numtrans,$amount,$urlRedirect){

        $MSG = "VERSION=".self::VERSION.
            "&TYPE=".self::TYPE_CANCEL.
            "&SITE=".$this->site.
            "&RANG=".$this->rang.
            "&NUMQUESTION=".$this->getNumQuestion().
            "&NUMAPPEL=".$numappel.
            "&REFERENCE=".$reference.
            "&NUMTRANS=".$numtrans.
            "&MONTANT=".$amount.
            "&DEVISE=".$this->devise.
            "&HASH=".self::HASH.
            "&DATEQ=".$this->getCurrentDate();

        header('location: '.$urlRedirect.'?'. $this->executePayment($MSG));

    }

    /**
     * @param $numappel
     * @param $numtrans
     * @param $amount
     * @param $urlRedirect
     */
    public function consultation($numappel,$numtrans,$amount,$urlRedirect){

        $MSG = "VERSION=".self::VERSION.
            "&TYPE=".self::TYPE_CONSULTATION.
            "&SITE=".$this->site.
            "&RANG=".$this->rang.
            "&NUMQUESTION=".$this->getNumQuestion().
            "&NUMAPPEL=".$numappel.
            "&NUMTRANS=".$numtrans.
            "&MONTANT=".$amount.
            "&DEVISE=".$this->devise.
            "&HASH=".self::HASH.
            "&DATEQ=".$this->getCurrentDate();

        header('location: '.$urlRedirect.'?'. $this->executePayment($MSG));

    }

    /**
     * @param $msg
     * @return mixed
     */
    private function executePayment($msg){
        $postMessage = $msg.'&HMAC='.$this->getHmacMessage($msg);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$this->url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt(
            $ch,
            CURLOPT_POSTFIELDS,
            $postMessage
        );

        // Receive server response ...
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $serverResponse = curl_exec($ch);

        curl_close ($ch);

        return $serverResponse;
    }

    /**
     * @param $env
     * @param $msg
     * @return string
     */
    private function getHmacMessage($msg){
        // Convert string hmac to binary
        $binKey = pack("H*",$this->key);
        // On crée le message crypté
        $HMAC = strtoupper(hash_hmac(self::HASH, $msg, $binKey));
        return $HMAC;
    }


    /**
     * @return false|string
     */
    private function getNumQuestion(){
        return date('ymdhi');
    }

    /**
     * @return false|string
     */
    private function getCurrentDate(){
        return date('dmY');
    }
}