<?php


namespace Koralp\Payment;

use Stripe\Exception\ApiErrorException;
use Stripe\Stripe as StripeApi;
use Stripe\PaymentIntent;

class Stripe
{
    public $key;

    public function __construct($key)
    {
        $this->key = $key;
    }

    /**
     * @param $card
     * @param $customerEmail
     * @param $amount
     * @param $currency
     * @param null $description
     * @param null $metatdata
     * @return array
     */
    public function pay($card, $customerEmail, $amount, $currency, $description = NULL, $metatdata = NULL){

        try {
            $stripe = new \Stripe\StripeClient($this->key);
            $cardToken = $stripe->tokens->create([
                'card' => $card,
            ]);

            $charge = $stripe->charges->create([
                'amount' => $amount,
                'currency' => $currency,
                'source' => $cardToken->id,
                'description' => $description,
                'receipt_email' => $customerEmail,
                'metadata' => $metatdata,
            ]);
        }
        catch(ApiErrorException $e){
            $error = $e->getError();
            return [
                'success' => false,
                'message' => $error->message,
                'code' => $error->code,
                'type' => $error->type,
            ];
        }
        catch(\Exception $e){
            return [
                'success' => false,
                'message' => $e->getMessage(),
            ];
        }

        return [
            'success' => true,
            'transactionId' => $charge->id
        ];
    }

}