<?php
/**
 * Created by PhpStorm.
 * User: AGO
 * Date: 09/06/2020
 * Time: 14:43
 */

namespace Koralp\Sms;

use Ovh\Api;

class Ovh
{
    const ENDPOINT = 'ovh-eu';
    private $applicationKey;
    private $applicationSecret;
    private $consumer_key;
    private $sender;

    /**
     * Ovh constructor.
     * @param $applicationKey
     * @param $applicationSecret
     * @param $consumer_key
     * @param $sender
     */
    public function __construct($applicationKey,$applicationSecret,$consumer_key,$sender)
    {
        $this->applicationKey = $applicationKey;
        $this->applicationSecret = $applicationSecret;
        $this->consumer_key = $consumer_key;
        $this->sender = $sender;
    }

    /**
     * @param $recipient
     * @param $message
     * @return mixed
     */
    public function send($recipient,$message){

        // Create connection
        $ovhConnection = new Api(
            $this->applicationKey,
            $this->applicationSecret,
            self::ENDPOINT,
            $this->consumer_key
        );


        // Get service linked to our account
        $smsServices = $ovhConnection->get('/sms/');


        // Set content
        $content = (object) array(
            "charset"=> "UTF-8",
            "class"=> "phoneDisplay",
            "coding"=> "7bit",
            'sender' => $this->sender,
            "message"=> $message,
            "noStopClause"=> true,
            "priority"=> "medium",
            "receivers"=> [$recipient],
            "senderForResponse"=> false,
            "validityPeriod"=> 2880
        );

        // Send message
        $resultPostJob = $ovhConnection->post('/sms/'. $smsServices[0] . '/jobs/', $content);

        return $resultPostJob;
    }

}